'Jesse Ruderman's Visual Basic Module Library
Option Explicit
DefDbl A-Z '(to make sure dividing is not "fixed")

'All variable passes are ByVal so that integers can be passed as
'single, etc.


'Function Comp (X As Integer, Y As Integer)

'Function GetNum (Stri As String, Place As Integer) As Double

'Function IsInt (X As Double) As Integer

'Function Max (X As Integer, Y As Integer) As Integer
'Function Min (X As Integer, Y As Integer)

'Function GCF (X As Integer, Y As Integer) As Integer
'Function LCM (X As Integer, Y As Integer) As Integer

'Function Get_Simp_Coef (Radicand As Integer) As Integer
     'Simplifies a radical.  Ex:  Radicand=12, returns 2.
     'In calling procedure, radicand=12/(2*2)

'Function num_to_s (X As Double) As String
     'Turns number into a string representing it.

Function Comp (ByVal X As Double, ByVal Y As Double)
' X>Y:  1
' X=Y:  0
' X<Y: -1

Comp = Sgn(X - Y)
End Function

Function GCF (ByVal X As Integer, ByVal Y As Integer) As Integer
' Also, Euler's GCF method.
' M(1) > N(1)
'        m(i + 1) = n(i)
'        n(i + 1) = m(i) Mod n(i)
' when n(i) = 0, GCF = m(i)
X = Abs(X)
Y = Abs(Y)

Dim Z As Integer
For Z = Min(X, Y) To 1 Step -1
If IsInt(X / Z) And IsInt(Y / Z) Then Exit For
Next Z

GCF = Z
If X = 0 And Y <> 0 Then GCF = Y
If Y = 0 And X <> 0 Then GCF = X
If Y = 0 And X = 0 Then GCF = 1

End Function

Function Get_Simp_Coef (ByVal radicand As Integer) As Integer

If radicand < 0 Then
 MsgBox "Radical error: square root of negative (Get_Simp_Coef)"
 End
End If

If radicand = 0 Then
 Get_Simp_Coef = 1  'Avoid /0 error
 Exit Function
End If

Dim X As Integer
For X = Int(Sqr(radicand)) To 1 Step -1
 If IsInt(radicand / (X * X)) Then Exit For
Next X
Get_Simp_Coef = X
End Function

Function IsInt (ByVal X As Double) As Integer
IsInt = (X = Int(X))
End Function

Function LCM (ByVal X As Integer, ByVal Y As Integer) As Integer
Dim Z As Integer
For Z = max(X, Y) To X * Y
If IsInt(Z / X) And IsInt(Z / Y) Then Exit For
Next Z
LCM = Z
End Function

Function max (ByVal X As Integer, ByVal Y As Integer) As Integer
'larger of two numbers
If X > Y Then max = X Else max = Y
End Function

Function Min (ByVal X As Integer, ByVal Y As Integer)
'smaller of two numbers
If X > Y Then Min = Y Else Min = X
End Function

Function num_to_s (ByVal X As Double) As String
num_to_s = Trim$(Str$(X))
End Function

